<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head profile="http://gmpg.org/xfn/11">
	
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	
	<?php if (is_search()) { ?>
	   <meta name="robots" content="noindex, nofollow" /> 
	<?php } ?>

	<title>
		   <?php
		      if (function_exists('is_tag') && is_tag()) {
		         single_tag_title("Tag Archive for &quot;"); echo '&quot; - '; }
		      elseif (is_archive()) {
		         wp_title(''); echo ' Archive - '; }
		      elseif (is_search()) {
		         echo 'Search for &quot;'.wp_specialchars($s).'&quot; - '; }
		      elseif (!(is_404()) && (is_single()) || (is_page())) {
		         wp_title(''); echo ' - '; }
		      elseif (is_404()) {
		         echo 'Not Found - '; }
		      if (is_home()) {
		         bloginfo('name'); echo ' - '; bloginfo('description'); }
		      else {
		          bloginfo('name'); }
		      if ($paged>1) {
		         echo ' - page '. $paged; }
		   ?>
	</title>
	
	<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
	
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" />
	<link rel="stylesheet" href="<?php bloginfo("template_url"); ?>/shortcodes/styles.css" type="text/css" />
	<link rel="stylesheet" href="<?php bloginfo("template_url"); ?>/css/jquery.tabs.css" type="text/css" media="print, projection, screen" />

	
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<link href='http://fonts.googleapis.com/css?family=Magra:400,700|Oswald' rel='stylesheet' type='text/css'>



	<?php wp_head(); ?>


<script type="text/javascript" src="<?php bloginfo("template_url"); ?>/js/jquery.jcarousel.min.js"></script>
<script type="text/javascript" src="<?php bloginfo("template_url"); ?>/js/jquery.tabs.pack.js"></script>

<link rel="stylesheet" type="text/css" href="<?php bloginfo("template_url"); ?>/tango/skin.css" />

<script type="text/javascript">

jQuery(document).ready(function() {  
     jQuery('#mycarousel').jcarousel({wrap: 'circular'});
     jQuery('#mycarousel1').jcarousel({wrap: 'circular'});   
});
</script>
        <script type="text/javascript">
            $(function() {
                $('#container-1').tabs();
				$('#container-2').tabs();
            });
        </script>	
        	
</head>

<body <?php body_class(); ?>>

<?php global $data; ?>
		<div id="header-top-all">
			<div id="header-top">
				<div id="topnav">
					<?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'topnav' )); ?>
				</div>
				<div id="header-search">
					<form action="<?php bloginfo('siteurl'); ?>" id="searchform" method="get">
						<div>
							<input type="text" id="s" name="s" value="Search" onfocus="this.value=(this.value=='Search') ? '' : this.value;" onblur="this.value=(this.value=='') ? 'Search' : this.value;" />
							<input type="image" src="<?php echo get_template_directory_uri(); ?>/images/search-btn.png" value="Search" id="searchsubmit"  />
						</div>
					</form>			
				</div>			
			</div>
		</div>

<!-- Start Header -->
  <div id="header-all">
		<div id="header">
			<div id="logo"><a href="<?php echo get_option('home'); ?>/">
				<?php if($data['logo']<>''){ ?>
					<img src="<?php echo $data['logo']; ?>" alt="Logo" />
				<?php }else{ ?>	
					<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="Logo" />
				<?php } ?>	
		</a></div>
			<div class="right">
				<div id="mainnav">
          <?php wp_nav_menu( array( 'container_class' => 'menu-header', 'theme_location' => 'mainnav' )); ?>
        </div>        
			</div>
			<div class="clear"></div>
		</div>
	</div>	
<!-- End Header -->

	
	<div id="page-wrap">


