<?php
/* Add metaboxes to property type */

if ( !function_exists( 'houzez_property_type_add_meta_fields' ) ) :
	function houzez_property_type_add_meta_fields() {
		$houzez_meta = houzez_get_property_type_meta();
?>

	<div class="form-field">
		 <label for="Color"><?php _e( 'Global Color', 'houzez'); ?></label><br/>
		 <label><input type="radio" name="fave[color_type]" value="inherit" class="fave-radio color-type" <?php checked( $houzez_meta['color_type'], 'inherit' );?>> <?php _e( 'Inherit from default accent color', 'houzez' ); ?></label>
		 <label><input type="radio" name="fave[color_type]" value="custom" class="fave-radio color-type" <?php checked( $houzez_meta['color_type'], 'custom' );?>> <?php _e( 'Custom', 'houzez' ); ?></label>
		 <div id="fave_color_wrap">
		 <p>
		   	<input name="fave[color]" type="text" class="fave_colorpicker" value="<?php echo $houzez_meta['color']; ?>" data-default-color="<?php echo $houzez_meta['color']; ?>"/>
		 </p>
		 <?php if ( !empty( $colors ) ) { echo $colors; } ?>
		 </div>
		 <div class="clear"></div>
		 <p class="howto"><?php _e( 'Choose color', 'houzez' ); ?></p>
	</div>



	<?php
	}
endif;

add_action( 'property_type_add_form_fields', 'houzez_property_type_add_meta_fields', 10, 2 );


/**
*   ----------------------------------------------------------------------------------------------------------------------------------------------------
*   2.0 - Edit Category meta field
*   ----------------------------------------------------------------------------------------------------------------------------------------------------
*/

if ( !function_exists( 'houzez_property_type_edit_meta_fields' ) ) :
	function houzez_property_type_edit_meta_fields( $term ) {
		$houzez_meta = houzez_get_property_type_meta( $term->term_id );
?>
	  <?php

		$most_used = get_option( 'houzez_recent_colors' );

		$colors = '';

		if ( !empty( $most_used ) ) {
			$colors .= '<p>'.__( 'Recently used', 'houzez' ).': <br/>';
			foreach ( $most_used as $color ) {
				$colors .= '<a href="#" style="width: 20px; height: 20px; background: '.$color.'; float: left; margin-right:3px; border: 1px solid #aaa;" class="fave_colorpick" data-color="'.$color.'"></a>';
			}
			$colors .= '</p>';
		}

	?>

	 <tr class="form-field">
		<th scope="row" valign="top"><label><?php _e( 'Color', 'houzez' ); ?></label></th>
			<td>
				<label><input type="radio" name="fave[color_type]" value="inherit" class="fave-radio color-type" <?php checked( $houzez_meta['color_type'], 'inherit' );?>> <?php _e( 'Inherit from default accent color', 'houzez' ); ?></label> <br/>
				<label><input type="radio" name="fave[color_type]" value="custom" class="fave-radio color-type" <?php checked( $houzez_meta['color_type'], 'custom' );?>> <?php _e( 'Custom', 'houzez' ); ?></label>
			  <div id="fave_color_wrap">
			  <p>
			    	<input name="fave[color]" type="text" class="fave_colorpicker" value="<?php echo $houzez_meta['color']; ?>" data-default-color="<?php echo $houzez_meta['color']; ?>"/>
			  </p>
			  <?php if ( !empty( $colors ) ) { echo $colors; } ?>
				</div>
				<div class="clear"></div>
				<p class="howto"><?php _e( 'Choose color', 'houzez' ); ?></p>
			</td>
		</tr>

	<?php
	}
endif;

add_action( 'property_type_edit_form_fields', 'houzez_property_type_edit_meta_fields', 10, 2 );


if ( !function_exists( 'houzez_save_property_type_meta_fields' ) ) :
	function houzez_save_property_type_meta_fields( $term_id ) {

		if ( isset( $_POST['fave'] ) ) {

			$houzez_meta = array();

			$houzez_meta['color'] = isset( $_POST['fave']['color'] ) ? $_POST['fave']['color'] : 0;
			$houzez_meta['color_type'] = isset( $_POST['fave']['color_type'] ) ? $_POST['fave']['color_type'] : 0;

			update_option( '_houzez_property_type_'.$term_id, $houzez_meta );

			if ( $houzez_meta['color_type'] == 'custom' ) {
				houzez_update_recent_colors( $houzez_meta['color'] );
			}

			houzez_update_property_type_colors( $term_id, $houzez_meta['color'], $houzez_meta['color_type'] );
		}

	}
endif;

add_action( 'edited_property_type', 'houzez_save_property_type_meta_fields', 10, 2 );
add_action( 'create_property_type', 'houzez_save_property_type_meta_fields', 10, 2 );

?>