<?php
/**
 * Created by PhpStorm.
 * User: waqasriaz
 * Date: 27/09/16
 * Time: 5:03 PM
 * Since v1.4.0
 */
global $floor_plans;

$icon_rooms = houzez_option('icon_rooms', false, 'url' );
$icon_bathrooms = houzez_option('icon_bathrooms', false, 'url' );
$icon_prop_size = houzez_option('icon_prop_size', false, 'url' );

if( !empty( $floor_plans ) ) {
?>
<div class="property-plans detail-block">
    <div class="container">
        <div class="detail-title">
            <h2 class="title-left"><?php esc_html_e( 'Floor plans', 'houzez' ); ?></h2>
        </div>
        <div class="plan-tabber">
            <ul class="plan-tabs">
                <?php
                $i = 0;
                foreach( $floor_plans as $pln ):
                    $i++;
                    if( $i == 1 ) {
                        $active = 'class="active"';
                    } else {
                        $active = '';
                    }
                    echo '<li '.$active.'>'.esc_attr( $pln['fave_plan_title'] ).'</li>';
                endforeach;
                ?>
            </ul>
            <div class="tab-content">
                <?php
                $j = 0;
                foreach( $floor_plans as $plan ):
                    $j++;
                    if( $j == 1 ) {
                        $active_tab = 'active in';
                    } else {
                        $active_tab = '';
                    }
                    $price_postfix = '';
                    if( !empty( $plan['fave_plan_price_postfix'] ) ) {
                        $price_postfix = ' / '.$plan['fave_plan_price_postfix'];
                    }
                    $filetype = wp_check_filetype($plan['fave_plan_image']);
                    ?>

                    <div class="tab-pane fade <?php echo esc_attr( $active_tab );?>">
                        <div class="col-sm-12 col-xs-12">
                            <div class="floor-image">
                                <?php if( !empty( $plan['fave_plan_image'] ) ) { ?>
                                    <?php if($filetype['ext'] != 'pdf' ) { ?>
                                        <a data-fancy="property_gallery" href="<?php echo esc_url( $plan['fave_plan_image'] ); ?>"><img src="<?php echo esc_url( $plan['fave_plan_image'] ); ?>" alt="img" width="" height=""></a>
                                <?php } else { 
                                        $path = $plan['fave_plan_image'];
                                        $file = basename($path); 
                                        $file = basename($path, ".pdf");
                                        
                                        echo '<a href="'.esc_url( $plan['fave_plan_image'] ).'" download>'.$file.'</a>';
                                    }
                                 } ?>
                            </div>

                        </div>
                        
                    </div>


                <?php
                endforeach;
                ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>